package com.bxm.game.common.core.archives;

import com.bxm.game.common.core.controllers.ArchiveController;
import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.scene.SceneResponse;
import com.bxm.warcar.cache.KeyGenerator;

import java.util.Collection;
import java.util.Map;

/**
 * <p>自定义存档处理器</p>
 * 通过该接口的方法 {@link #getDisplayFieldName()} 获取的值将设置到返回结果的 {@code custom} 节点中，对应的值则是 {@link #getArchiveObjects()}。
 *
 * <pre>
 *     示例：
 *
 *     如果 getDisplayFieldName() 返回的值是：demo，
 *         getArchiveObjects() 返回的值是一个字符串：Hello,world!
 *
 *     那么最后通过接口 {@link ArchiveController#fetch()} 获取的 ArchiveVo 的结果则是：
 *     {
 *         "today" : {...}
 *         "custom" : {
 *             "demo" : [ "Hello,world!" ]
 *         }
 *     }
 * </pre>
 * @author allen
 * @date 2020-12-08
 * @since 1.0
 */
public interface CustomArchiveHandler<T> {

    /**
     * 返回在 {@code custom} 的子节点名称。
     * @return 名称
     */
    String getDisplayFieldName();

    /**
     * 获取所有的存档
     *
     * @return 存档
     */
    T getArchiveObjects();
}
