package com.bxm.game.common.core.archives.redis;

import java.util.Collection;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Qualifier;

import com.bxm.game.common.core.archives.CustomArchive;
import com.bxm.game.common.core.archives.CustomArchiveDataService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;

/**
 * @author allen
 * @date 2020-12-08
 * @since 1.0
 */
public class RedisCustomArchiveDataServiceImpl implements CustomArchiveDataService {

    private final Fetcher fetcher;
    private final Updater updater;

    public RedisCustomArchiveDataServiceImpl(@Qualifier("jedisFetcher") Fetcher fetcher,
                                             @Qualifier("jedisUpdater") Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public void hset(CustomArchive archive) {
        updater.hupdate(archive::getKey, archive.getField(), archive.getValue(), archive.getExpireTimeInSeconds());
    }

    @Override
    public void hdel(String key, String field) {
        updater.hremove(() -> key, field);
    }

    @Override
    public <T> Collection<T> hgetAll(String key, Class<T> clazz) {
        Map<String, T> map = fetcher.hfetchall(() -> key, clazz);
        if (MapUtils.isNotEmpty(map)) {
            return map.values();
        }
        return null;
    }
}
