package com.bxm.game.common.core.assets;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 资产（货币）记录<br/>
 *
 * @author kerry.jiang
 * @date 2021/5/17 10:21
 */
@Data
@Accessors(chain = true)
public class AssetLog {

    /**
     * 流水号
     */
    private String assetsNo;

    /**
     * appid
     */
    private String appId;

    /**
     * 变现猫用户ID
     */
    private String uid;

    /**
     * app用户ID
     */
    private String appUid;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 资产类型
     */
    private String assetType;

    /**
     * 资产数量
     */
    private Integer assetNum;

    /**
     * 操作类型,1:增加,2:扣除
     */
    private Integer operateType;

    /**
     * 操作状态,1:成功,2:失败
     */
    private Integer operateStatus;

    /**
     * 接口调用状态,1:正常,2:错误,3:超时
     */
    private Integer apiStatus;

    /**
     * 行为
     */
    private String act;
}
