package com.bxm.game.common.core.assets;

import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.game.common.dal.entity.AssetsLog;
import com.bxm.game.common.dal.model.AssetsLogRequest;

/**
 * 资产（货币）记录<br/>
 *
 * @author kerry.jiang
 * @date 2021/5/17 10:19
 */
public interface AssetLogService {

    /**
     * 保存记录
     * @param log
     */
    @Transactional(rollbackFor = Exception.class)
    void saveLog(AssetLog log);

    /**
     * 查询用户货币记录<br/>
     *
     * @param page 分页信息
     * @param request 请求参数
     * @return
     */
    Page<AssetsLog> pageByUid(Page page, AssetsLogRequest request);
}
