package com.bxm.game.common.core.assets;

import java.time.LocalDateTime;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.dal.entity.AssetsLog;
import com.bxm.game.common.dal.entity.AssetsLogYmd;
import com.bxm.game.common.dal.mapper.AssetsLogMapper;
import com.bxm.game.common.dal.mapper.AssetsLogYmdMapper;
import com.bxm.game.common.dal.model.AssetsLogRequest;
import com.bxm.game.common.dal.service.IAssetsLogService;
import com.bxm.warcar.id.IdGenerator;

/**
 * 资产（货币）记录<br/>
 *
 * @author kerry.jiang
 * @date 2021/5/17 10:23
 */
public class AssetLogServiceImpl implements AssetLogService {

    @Autowired
    private AssetsLogMapper assetsLogMapper;
    @Autowired
    private IAssetsLogService iAssetsLogService;
    @Autowired
    private AssetsLogYmdMapper assetsLogYmdMapper;
    @Autowired
    private AppConfigFetcher appConfigFetcher;
    @Autowired
    private IdGenerator id;

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void saveLog(AssetLog log) {
        LocalDateTime createTime = LocalDateTime.now();
        String assetsNo = (null == log.getAssetsNo() ? id.next() : log.getAssetsNo());
        // 月表
        AssetsLog assetsLog = new AssetsLog()
                .setAssetsNo(assetsNo)
                .setAppId(log.getAppId())
                .setUid(log.getUid())
                .setAppUid(log.getAppUid())
                .setActivityType(log.getActivityType())
                .setAssetType(log.getAssetType())
                .setAssetNum(log.getAssetNum())
                .setOperateType(log.getOperateType())
                .setOperateStatus(log.getOperateStatus())
                .setApiStatus(log.getApiStatus())
                .setAct(log.getAct())
                .setCreateTime(createTime);
        assetsLogMapper.insert(assetsLog);

        // 日表
        AssetsLogYmd assetsLogYmd = new AssetsLogYmd()
                .setAssetsNo(assetsNo)
                .setAppId(log.getAppId())
                .setUid(log.getUid())
                .setAppUid(log.getAppUid())
                .setActivityType(log.getActivityType())
                .setAssetType(log.getAssetType())
                .setAssetNum(log.getAssetNum())
                .setOperateType(log.getOperateType())
                .setOperateStatus(log.getOperateStatus())
                .setApiStatus(log.getApiStatus())
                /**
                 * TODO 没有加上的原因：目前会多个项目同时任务，因此需要在所有使用该模块的游戏中升级game-common
                 * @see AssetsLogYmdMapper.XML "createTable"
                 */
//                .setAct(log.getAct())
                .setCreateTime(createTime);
        assetsLogYmdMapper.insert(assetsLogYmd);
    }

    @Override
    public Page<AssetsLog> pageByUid(Page page, AssetsLogRequest request) {
        return iAssetsLogService.pageByUid(appConfigFetcher.databaseName(),
                page, request);
    }
}
