package com.bxm.game.common.core.assets;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.bxm.game.common.core.user.DefaultTimeBoundService;
import com.bxm.game.common.core.user.TimeBoundService;

import lombok.extern.slf4j.Slf4j;

/**
 * 基于时效周期的资产服务<br/>
 *
 * @author kerry.jiang
 * @date 2021/1/6 17:46
 */
@Slf4j
public class DefaultTimeBoundAssetServiceImpl implements AssetService {

    private final String BOUND_ASSET = TimeBoundService.TYPE_ASSET;

    @Autowired(required = false)
    protected DefaultTimeBoundService defaultTimeBoundService;

    @Override
    public long plus(String type, long value, String act) {
        return defaultTimeBoundService.hIncrBy(BOUND_ASSET, type, value);
    }

    @Override
    public long minus(String type, long value, String act) {
        return defaultTimeBoundService.hIncrBy(BOUND_ASSET, type, -value);
    }

    @Override
    public long get(String type) {
        return defaultTimeBoundService.hGet(BOUND_ASSET, type);
    }

    @Override
    public long get(String type, long defaultValue) {
        return defaultTimeBoundService.hGet(BOUND_ASSET, type, defaultValue);
    }

    @Override
    public void set(String type, long value) {
        defaultTimeBoundService.hSet(BOUND_ASSET, type, String.valueOf(value));
    }

    @Override
    public void delete(String type) {
        defaultTimeBoundService.hDel(BOUND_ASSET, type);
    }

    @Override
    public Map<String, Object> getAll() {
        Map<String, Object> rst = new HashMap<>();
        Map<String, String> map = defaultTimeBoundService.hGetAll(BOUND_ASSET, String.class);
        if (MapUtils.isEmpty(map)) {
            return rst;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (NumberUtils.isCreatable(value)) {
                rst.put(key, NumberUtils.toInt(value));
            } else {
                rst.put(key, value);
            }
        }
        return rst;
    }
}
