package com.bxm.game.common.core.assets.dao;

import java.util.Map;

/**
 * @author allen
 * @date 2020-12-15
 * @since 1.0
 */
public interface AssetDao {

    /**
     * 增加资产
     *
     * @param type 资产类型
     * @param value 资产值
     * @return 增加之后的值
     */
    long plus(String type, long value);

    /**
     * 减少资产
     * @param type 资产类型
     * @param value 资产值
     * @return 减少之后的值
     */
    long minus(String type, long value);

    /**
     * 获取资产
     *
     * @param type 资产类型
     * @return 资产
     */
    long get(String type);

    /**
     * 获取资产，当不存在时返回 {@code defaultValue}
     * @param type 资产类型
     * @param defaultValue 不存在时返回值
     * @return 资产
     */
    long get(String type, long defaultValue);

    /**
     * 设置资产
     * @param type 资产类型
     * @param value 资产值
     */
    void set(String type, long value);

    /**
     * 删除资产数据
     * @param type 资产类型
     */
    void delete(String type);

    /**
     * 获取全部资产
     *
     * @return 资产
     */
    Map<String, Object> getAll();
}
