package com.bxm.game.common.core.autoconfigure;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

import com.bxm.game.common.core.autoconfigure.config.CommonRedisConfig;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;

import redis.clients.jedis.JedisPool;

/**
 * 公共存储redis<br/>
 * 如：用户玩过的游戏<br/>
 *
 * @author kerry.jiang
 * @date 2021/4/2 14:35
 */
@EnableConfigurationProperties(CommonRedisConfig.class)
@ConditionalOnProperty(name = "game.common.jedis.host")
public class CommonRedisAutoConfiguration {

    private final CommonRedisConfig commonRedisConfig;

    public CommonRedisAutoConfiguration(CommonRedisConfig commonRedisConfig) {
        this.commonRedisConfig = commonRedisConfig;
    }

    /**
     * 连接池
     */
    @Bean
    public JedisPool commonPool() {
        return new JedisPool(commonRedisConfig, commonRedisConfig.getHost(),
                commonRedisConfig.getPort(), commonRedisConfig.getTimeout(),
                commonRedisConfig.getPassword(), commonRedisConfig.getDatabase());
    }

    /**
     * JedisFetcher
     */
    @Bean
    public JedisFetcher commonFetcher(@Qualifier("commonPool") JedisPool commonPool) {
        return new JedisFetcher(commonPool);
    }

    /**
     * JedisUpdater
     */
    @Bean
    public JedisUpdater commonUpdater(@Qualifier("commonPool") JedisPool commonPool) {
        return new JedisUpdater(commonPool);
    }

    /**
     * JedisCounter
     */
    @Bean
    public JedisCounter commonCounter(@Qualifier("commonPool") JedisPool commonPool) {
        return new JedisCounter(commonPool);
    }
}
