package com.bxm.game.common.core.autoconfigure;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

import com.bxm.game.common.core.AppConfig;
import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.assets.dao.AssetDao;
import com.bxm.game.common.core.assets.dao.ObjectAssetDao;
import com.bxm.game.common.core.assets.dao.RedisAssetDaoImpl;
import com.bxm.game.common.core.assets.dao.RedisObjectAssetDaoImpl;
import com.bxm.game.common.core.prop.dao.PropDao;
import com.bxm.game.common.core.prop.dao.RedisPropDaoImpl;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;

/**
 * @author allen
 * @date 2020-12-15
 * @since 1.0
 */
@ConditionalOnProperty(name = "game.datasource.type", havingValue = "redis", matchIfMissing = true)
public class RedisAutoConfiguration {

    @Bean
    public static PropDao propDao(AppConfig appConfig,
                                  @Qualifier("jedisFetcher") Fetcher fetcher,
                                  @Qualifier("jedisUpdater") Updater updater) {
        return new RedisPropDaoImpl(appConfig, fetcher, updater);
    }

    @Bean
    public static AssetDao assetDao(AppConfigFetcher appConfigFetcher, Key key,
                                    @Qualifier("jedisFetcher") Fetcher fetcher,
                                    @Qualifier("jedisCounter") Counter counter,
                                    @Qualifier("jedisUpdater") Updater updater) {
        return new RedisAssetDaoImpl(appConfigFetcher, fetcher, counter, updater, key);
    }

    @Bean
    public static ObjectAssetDao objectAssetDao(AppConfigFetcher appConfigFetcher, Key key,
                                                @Qualifier("jedisFetcher") Fetcher fetcher,
                                                @Qualifier("jedisUpdater") Updater updater) {
        return new RedisObjectAssetDaoImpl(appConfigFetcher, fetcher, updater, key);
    }
}
