package com.bxm.game.common.core.autoconfigure.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

import lombok.Data;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Protocol;

/**
 * 公共存储redis<br/>
 * 如：用户玩过的游戏<br/>
 *
 * @author kerry.jiang
 * @date 2021/4/2 14:23
 */
@Data
@ConfigurationProperties(prefix = "game.common.jedis")
public class CommonRedisConfig extends JedisPoolConfig {

    private String host = Protocol.DEFAULT_HOST;
    private String password;
    private int port = Protocol.DEFAULT_PORT;
    private int timeout = Protocol.DEFAULT_TIMEOUT;
    private int database = Protocol.DEFAULT_DATABASE;
}
