package com.bxm.game.common.core.config;

import java.util.Map;

import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * 场景配置信息<br/>
 *
 * @author kerry.jiang
 * @date 2021/4/22 18:24
 */
@Slf4j
public class SceneConfigServiceFactory implements ApplicationListener<ApplicationReadyEvent> {

    private final Map<String, SceneConfigFetcher> map = Maps.newHashMap();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map<String, SceneConfigFetcher> beans = applicationContext.getBeansOfType(SceneConfigFetcher.class);
        for (SceneConfigFetcher service : beans.values()) {
            map.put(service.getSceneType(), service);
            log.info("Registering SceneConfigFetcher to Factory: {}", service);
        }
    }

    public SceneConfigFetcher get(String sceneType) {
        return map.get(sceneType);
    }
}
