package com.bxm.game.common.core.controllers;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.game.common.core.job.AssetJobService;
import com.bxm.game.common.core.job.SynAssetRequest;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;

import lombok.extern.slf4j.Slf4j;

/**
 * 调度作业<br/>
 *
 * @author kerry.jiang
 * @date 2021/1/14 16:11
 */
@Slf4j
@RestController
@RequestMapping("/job")
public class JobController {

    private final AssetJobService assetJobService;

    public JobController(AssetJobService assetJobService){
        this.assetJobService = assetJobService;
    }

    /**
     * 同步资产
     */
    @GetMapping("/synAsset")
    public ResultModel<Boolean> synAsset(SynAssetRequest request) {
        assetJobService.synAsset(request);
        return ResultModelFactory.SUCCESS(Boolean.TRUE);
    }
}
