package com.bxm.game.common.core.controllers;

import java.util.List;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import com.bxm.game.common.core.withdraw.WithdrawRequest;
import com.bxm.game.common.core.withdraw.WithdrawResponse;
import com.bxm.game.common.core.withdraw.WithdrawService;
import com.bxm.game.common.core.withdraw.dao.WithdrawDao;

/**
 * 用户提现-网络版<br/>
 *
 * @author kerry.jiang
 * @date 2021/3/23 17:01
 */
@RestController
@RequestMapping("/withdraw")
@ConditionalOnBean(WithdrawDao.class)
public class WithdrawController {

    private final WithdrawService withdrawService;

    public WithdrawController(WithdrawService withdrawService) {
        this.withdrawService = withdrawService;
    }

    /**
     * 用户提现<br/>
     */
    @PostMapping("/submit")
    public ResponseEntity<String> submit(@Validated @RequestBody WithdrawRequest request) {
        withdrawService.withdraw(request);
        return ResponseEntity.ok().build();
    }

    /**
     * 提现记录
     */
    @GetMapping("/log")
    public ResponseEntity<List<WithdrawResponse>> log() {
        return ResponseEntity.ok(withdrawService.list());
    }
}
