package com.bxm.game.common.core.controllers;

import java.util.List;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import com.bxm.game.common.core.withdraw.*;
import com.bxm.game.common.core.withdraw.dao.WithdrawLocalDao;

/**
 * 用户提现-本地版<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/20 11:13
 */
@RestController
@RequestMapping("/withdrawlocal")
@ConditionalOnBean(WithdrawLocalDao.class)
public class WithdrawLocalController {

    private final WithdrawLocalService withdrawService;

    public WithdrawLocalController(WithdrawLocalService withdrawService) {
        this.withdrawService = withdrawService;
    }

    /**
     * 用户提现<br/>
     */
    @PostMapping("/submit")
    public ResponseEntity<String> submit(@Validated @RequestBody WithdrawLocalRequest request) {
        withdrawService.withdraw(request);
        return ResponseEntity.ok().build();
    }

    /**
     * 提现记录
     */
    @GetMapping("/log")
    public ResponseEntity<List<WithdrawLocalResponse>> log(WithdrawLocalRequest request) {
        return ResponseEntity.ok(withdrawService.list(request));
    }
}
