package com.bxm.game.common.core.job;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.dal.entity.AssetsLog;
import com.bxm.game.common.dal.entity.AssetsLogYmd;
import com.bxm.game.common.dal.service.IAssetsLogService;
import com.bxm.game.common.dal.service.IAssetsLogYmdService;
import com.bxm.warcar.utils.NamedThreadFactory;

/**
 * 定时创建分表<br/>
 *
 * @author kerry.jiang
 * @date 2021/1/12 19:14
 */
public class TableJobServiceImpl implements TableJobService {


    private final AppConfigFetcher appConfigFetcher;
    private final IAssetsLogService iAssetsLogService;
    private final IAssetsLogYmdService iAssetsLogYmdService;

    public TableJobServiceImpl(AppConfigFetcher appConfigFetcher, IAssetsLogService iAssetsLogService,
                               IAssetsLogYmdService iAssetsLogYmdService){
        this.appConfigFetcher = appConfigFetcher;
        this.iAssetsLogService = iAssetsLogService;
        this.iAssetsLogYmdService = iAssetsLogYmdService;
    }

    /**
     * 定时器 - assets_log_{yyyyMMdd}
     */
    private ScheduledThreadPoolExecutor createOfAssetsLogJob;

    @Override
    public void createOfAssetsLogJob() {
        if(null != createOfAssetsLogJob){
            return;
        }
        createOfAssetsLogJob = new ScheduledThreadPoolExecutor(1,
                new NamedThreadFactory("createOfAssetsLogJob"));

        createOfAssetsLogYMD(0);
        createOfAssetsLogYM(0);
        createOfAssetsLogJob.scheduleWithFixedDelay(() -> {
            createOfAssetsLogYMD(1);
            createOfAssetsLogYM(1);
        }, 0, 1, TimeUnit.DAYS);
    }

    /**
     * 创建日表
     */
    private void createOfAssetsLogYMD(int daysToAdd) {
        final String tableName = AssetsLogYmd.getTableName(daysToAdd);
        iAssetsLogYmdService.createTableIfNecessary(appConfigFetcher.databaseName(), tableName);
    }

    /**
     * 创建月表
     */
    private void createOfAssetsLogYM(int monthsToAdd) {
        final String tableName = AssetsLog.getTableName(monthsToAdd);
        iAssetsLogService.createTableIfNecessary(appConfigFetcher.databaseName(), tableName);
    }
}
