package com.bxm.game.common.core.scene;

import java.util.EventObject;

import lombok.Getter;

/**
 * 道具通过 以下 场景获取后触发的事件。
 *
 * <li>{@link com.bxm.game.common.core.scene.SceneType#ACQUIRE}</li>
 * <li>{@link com.bxm.game.common.core.scene.SceneType#MULTIPLE}</li>
 *
 * @author allen
 * @date 2020-12-02
 * @since 1.0
 */
@Getter
public class AcquiringOrMultiplyPropEvent extends EventObject {

    private final SceneRequest request;
    private final SceneResponse response;
    /**
     * 事件源场景，如：signin等
     */
    private final String sceneType;

    public AcquiringOrMultiplyPropEvent(Object source, SceneRequest request, SceneResponse response,
                                        String sceneType) {
        super(source);
        this.request = request;
        this.response = response;
        this.sceneType = sceneType;
    }
}
