package com.bxm.game.common.core.user;

import java.util.function.Predicate;

/**
 * 默认时效性<br/>
 *
 * @author kerry.jiang
 * @date 2021/3/17 19:48
 */
public interface DefaultTimeBoundService extends TimeBoundService {

    /**
     * 保存值
     * @param type 时效类目，用于{@code key.getTimeBound(type)}
     * @param value 值
     */
    default void set(String type, String value){
        set(type, value, getTtl());
    }

    /**
     * 在当前 {@code key} 对应的数值 +1
     * @param type 时效类目，用于{@code key.getTimeBound(type)}
     * @return 增加后的数值
     */
    default long incr(String type) {
        return incr(type, getTtl());
    }

    /**
     * 在当前 {@code key} 对应的数值增量 {@code value}
     * @param type 时效类目，用于{@code key.getTimeBound(type)}
     * @param value value
     * @return 增加后的数值
     */
    default long incrBy(String type, long value){
        return incrBy(type, value, getTtl());
    }

    /**
     * 在当前 {@code key} 对应的数值 +1，并判断返回的值是否大于 {@code above}
     *
     * @param type 时效类目，用于{@code key.getTimeBound(type)}
     * @param above 比较值
     * @return 判断结果
     */
    default boolean incrAndAbove(String type, long above) {
        return incrAndAbove(type, above, getTtl());
    }

    /**
     * 在当前 {@code key} 对应的数值 +1，并返回 {@code predicate} 判断后的结果
     * @param type 时效类目，用于{@code key.getTimeBound(type)}
     * @param predicate 判断接口，参数值为增加后的数值
     * @return 判断结果
     */
    default boolean incr(String type, Predicate<Long> predicate) {
        return incr(type, predicate, getTtl());
    }

    /**
     * 在当前 {@code key} 对应的数值增量 {@code value}，并返回 {@code predicate} 判断后的结果
     * @param type 时效类目，用于{@code key.getTimeBound(type)}
     * @param value value
     * @param predicate 判断接口，参数值为增加后的数值
     * @return 判断结果
     */
    default boolean incrBy(String type, long value, Predicate<Long> predicate){
        return incrBy(type, value, predicate, getTtl());
    }

    /**
     * 保存值
     * @param type 时效类目，用于{@code key.getTimeBound(type)}
     * @param value 值
     */
    default void hSet(String type, String field, String value){
        hSet(type, field, value, getTtl());
    }

    /**
     * 在当前 {@code key} 对应的数值 +1
     * @param type 时效类目，用于{@code key.getTimeBound(type)}
     * @param field field
     * @return 增加后的数值
     */
    default long hIncr(String type, String field) {
        return hIncr(type, field, getTtl());
    }

    /**
     * 在当前 {@code key} 对应的数值增量 {@code value}
     * @param type 时效类目，用于{@code key.getTimeBound(type)}
     * @param field field
     * @param value value
     * @return 增加后的数值
     */
    default long hIncrBy(String type, String field, long value){
        return hIncrBy(type, field, value, getTtl());
    }

    /**
     * 在当前 {@code key} 对应的数值 +1，并判断返回的值是否大于 {@code above}
     *
     * @param type 时效类目，用于{@code key.getTimeBound(type)}
     * @param field field
     * @param above 比较值
     * @return 判断结果
     */
    default boolean hIncrAndAbove(String type, String field, long above) {
        return hIncrAndAbove(type, field, above);
    }

    /**
     * 在当前 {@code key} 对应的数值 +1，并返回 {@code predicate} 判断后的结果
     * @param type 时效类目，用于{@code key.getTimeBound(type)}
     * @param field field
     * @param predicate 判断接口，参数值为增加后的数值
     * @return 判断结果
     */
    default boolean hIncr(String type, String field, Predicate<Long> predicate) {
        return hIncr(type, field, predicate, getTtl());
    }

    /**
     * 在当前 {@code key} 对应的数值增量 {@code value}，并返回 {@code predicate} 判断后的结果
     * @param type 时效类目，用于{@code key.getTimeBound(type)}
     * @param field field
     * @param value value
     * @param predicate 判断接口，参数值为增加后的数值
     * @return 判断结果
     */
    default boolean hIncrBy(String type, String field, long value, Predicate<Long> predicate){
        return hIncrBy(type, field, value, predicate, getTtl());
    }
}