package com.bxm.game.common.core.util;

import java.util.*;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

/**
 * 中国周（周一 ~ 周日）<br/>
 *
 * @author kerry.jiang
 * @date 2021/4/26 10:43
 */
public class WeekCNHelper {

    /**
     * 获取本周的第几天（1~7表示周一 ~ 周日）<br/>
     *
     * @param date 日期
     * @return
     */
    public static int orderDaysOfWeek(Date date){
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setTime(date);
        int days = cld.get(Calendar.DAY_OF_WEEK);
        if(days == 1){// 星期天
            days = 8;
        }
        return days - 1;
    }

    /**
     * 获取本周的所有日期（周一 ~ 周日）<br/>
     *
     * @param date 日期
     * @return
     */
    public static List<Date> getDaysOfWeek(Date date){
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setTime(date);
        int days = cld.get(Calendar.DAY_OF_WEEK);
        if(days == 1){// 星期天
            days = 8;
        }
        int minus = days - 2;
        int plus = 8 - days;
        List<Date> dates = new ArrayList<>();
        if(minus > 0){
            for (int i = minus; i > 0; i--) {
                dates.add(DateUtils.addDays(date, -i));
            }
        }
        dates.add(date);
        if(plus > 0){
            for (int i = 1; i <= plus; i++) {
                dates.add(DateUtils.addDays(date, i));
            }
        }
        return dates;
    }

    /**
     * 当年第几周(中式周,跨年时以周一所在年为准)<br/>
     * 如：
     *   2002-1-1 -> 200153
     *   2018-1-1 -> 201801
     * @date 日期
     * @return
     */
    public static String getWeekOfYear(Date date){
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setFirstDayOfWeek(Calendar.MONDAY);//以周一为首日
        cld.setTime(date);
        cld.setMinimalDaysInFirstWeek(7);//至少有7天在本年，才能算为本年第一周
        int year = cld.get(Calendar.YEAR);
        int days = cld.get(Calendar.DAY_OF_YEAR);
        int weeks = cld.get(Calendar.WEEK_OF_YEAR);
        if(days < 7){//年初
            if(weeks > 50){//一年中的最后一周
                year --;
            }
        }
        if(weeks > 9){
            return StringUtils.join(new Object[]{year, weeks});
        }else{
            return StringUtils.join(new Object[]{year, 0, weeks});
        }
    }
}
