package com.bxm.game.common.core.vo;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author allen
 * @date 2020-12-11
 * @since 1.0
 */
@Data
public class BasePage {

    @NotNull(message = "每页显示数量不能为空")
    @Min(value = 1, message = "每页显示数量不能小于1")
    @Max(value = 999, message = "每页显示数量不能大于999")
    private Integer size = 20;
    @NotNull(message = "页码不能为空")
    @Min(value = 1, message = "页码不能小于1")
    private Integer current = 1;
}
