package com.bxm.game.common.core.vo;

import com.bxm.game.common.core.archives.CustomArchiveHandlerFactory;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

import java.util.Map;
import java.util.Set;

/**
 * @author allen
 * @date 2020-12-01
 * @since 1.0
 * @deprecated We recommend using {@link CustomArchiveHandlerFactory}
 */
@Slf4j
@Deprecated
public class CustomArchiveFetcherFactory implements ApplicationListener<ApplicationReadyEvent> {

    private final Set<CustomArchiveFetcher> fetchers = Sets.newHashSet();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        Map<String, CustomArchiveFetcher> beans = event.getApplicationContext().getBeansOfType(CustomArchiveFetcher.class);
        for (CustomArchiveFetcher bean : beans.values()) {
            fetchers.add(bean);
            log.info("Registering CustomArchiveFetcher to Factory: {}", bean);
        }
    }

    public ImmutableSet<CustomArchiveFetcher> getFetchers() {
        return ImmutableSet.copyOf(fetchers);
    }
}
