package com.bxm.game.common.core.vo;

import java.util.Map;

import com.bxm.game.common.core.user.PermanentAtomicService;
import com.bxm.game.common.core.user.TodayAtomicService;

/**
 * 数据转换器，可将原始存储在 {@link com.bxm.game.common.core.user.AtomicService} 的数据进行转换成期望的数据集。
 *
 * @author allen
 * @date 2020-12-02
 * @since 1.0
 * @see ArchiveVo#getToday()
 * @see ArchiveVo#getPermanent()
 * @see TodayAtomicService#getAll()
 * @see PermanentAtomicService#getAll()
 */
public interface DataTransfer {

    /**
     * 转换数据
     * @param type 数据类型
     * @param source 原始数据
     * @return 转换后期望的数据集
     */
    Map<String, Object> transfer(DataTypeEnum type, Map<String, Object> source);
}
