package com.bxm.game.common.core.vo;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author allen
 * @date 2020-04-16
 * @since 1.0
 */
public final class PageHelper {

    public static <T> IPage<T> create(IPage<?> source, List<T> records) {
        return create(source.getCurrent(), source.getSize(), source.getTotal(), records);
    }

    public static <T> IPage<T> create(long current, long size, long total, List<T> records) {
        IPage<T> page = new Page<>(current, size, total);
        page.setRecords(records);
        return page;
    }

    public static <S, D> IPage<D> selectForObject(int current, int size, Extractor<S> extractor, Constructor<S, D> constructor) {
        IPage<S> page = new Page<>(current, size);
        IPage<S> extract = extractor.extract(page);
        if (null == extract) {
            return null;
        }
        IPage<D> result = new Page<>(extract.getCurrent(), extract.getSize(), extract.getTotal());
        List<S> records = extract.getRecords();
        if (CollectionUtils.isEmpty(records)) {
            return result;
        }

        List<D> list = records.stream().map(constructor::construct).collect(Collectors.toList());
        result.setRecords(list);
        return result;
    }
}
