package com.bxm.game.common.core.withdraw;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * 提现请求-本地版<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/20 11:55
 */
@Data
public class WithdrawLocalRequest {

    /**
     * 应用id
     */
    @NotBlank(message = "应用id")
    private String appid;
    /**
     * 用户id
     */
    @NotBlank(message = "用户id")
    private String uid;
    /**
     * 用户姓名
     */
    @NotBlank(message = "用户姓名")
    private String name;
    /**
     * 联系电话
     */
    @NotBlank(message ="联系电话")
    private String mobile;
    /**
     * 提现方式,0:无,1:支付宝,2:微信
     */
    @NotNull(message = "提现方式")
    private Integer payType;
    /**
     * 提现账号
     */
    @NotBlank(message = "提现账号")
    private String account;
    /**
     * 提现金额
     */
    @NotNull(message = "提现金额")
    private Integer amount;
}
