package com.bxm.game.common.core.withdraw;

import java.time.LocalDateTime;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 提现记录<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/20 11:55
 */
@Data
@Accessors(chain = true)
public class WithdrawLocalResponse {

    /**
     * ID
     */
    private Long id;

    /**
     * 提现单号
     */
    private String orderId;

    /**
     * 应用ID
     */
    private String appId;

    /**
     * 变现猫用户ID
     */
    private String uid;

    /**
     * 提现状态,1:待发放,2:已发放,3:已放弃
     */
    private Integer status;

    /**
     * 申请时间
     */
    private LocalDateTime createTime;

    /**
     * 用户姓名
     */
    private String name;

    /**
     * 联系电话
     */
    private String mobile;
    /**
     * 提现方式,0:无,1:支付宝,2:微信
     */
    private Integer payType;
    /**
     * 提现账号
     */
    private String account;

    /**
     * 提现金额,单位：分
     */
    private Integer amount;
}
