package com.bxm.game.common.core.withdraw;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.ErrCode;
import com.bxm.game.common.core.GameException;
import com.bxm.game.common.core.withdraw.dao.WithdrawLocalDao;
import com.bxm.game.common.dal.entity.PrizeLogLocal;
import com.bxm.game.common.dal.service.IPrizeLogLocalService;
import com.bxm.warcar.id.IdGenerator;

import lombok.extern.slf4j.Slf4j;

/**
 * 提现服务-本地版<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/20 10:55
 */
@Slf4j
@ConditionalOnBean(WithdrawLocalDao.class)
public class WithdrawLocalServiceImpl implements WithdrawLocalService {

    /**
     * 待发放
     */
    private final int STATUS_SUBMIT = 1;

    private final IPrizeLogLocalService iPrizeLogService;
    private final AppConfigFetcher appConfigFetcher;
    private final IdGenerator id;
    private final WithdrawLocalDao withdrawDao;

    public WithdrawLocalServiceImpl(IPrizeLogLocalService iPrizeLogService, AppConfigFetcher appConfigFetcher,
                               IdGenerator id, WithdrawLocalDao withdrawDao) {
        this.iPrizeLogService = iPrizeLogService;
        this.appConfigFetcher = appConfigFetcher;
        this.id = id;
        this.withdrawDao = withdrawDao;
    }

    @Override
    public void withdraw(WithdrawLocalRequest request) {
        Map<Object, Object> attach = new HashMap<>();
        // 校验提现条件
        if(!withdrawDao.check(request, attach)){
            return ;
        }

        // 提现金额转元
        Double yuan = withdrawDao.toYuan(request, attach);
        BigDecimal bd = new BigDecimal(String.valueOf(yuan));
        Double fen = yuan * 100;

        PrizeLogLocal prizeLog = new PrizeLogLocal()
                .setOrderId(id.next())
                .setAppId(request.getAppid())
                .setUid(request.getUid())
                .setAppUid(StringUtils.EMPTY)
                .setStatus(STATUS_SUBMIT)
                .setPrizeId(0L)
                .setPrizeName(bd.setScale(2, RoundingMode.HALF_UP).toString())
                .setPrizeNum(1)
                .setName(request.getName())
                .setMobile(request.getMobile())
                .setAddress(StringUtils.EMPTY)
                .setActivityType(appConfigFetcher.activityType())
                .setPayType(request.getPayType())
                .setAccount(request.getAccount())
                .setAmount(fen.intValue());

        // 提现记录保存前,处理提现记录
        withdrawDao.handlePrizeLog(prizeLog, attach);

        try {
            if (!iPrizeLogService.save(prizeLog)) {
                throw new GameException(ErrCode.WITHDRAW_ERR);
            }
            log.info("PrizeLog: {}", prizeLog);
        } catch (Exception e) {
            log.error("save: ", e);
            throw new GameException(ErrCode.WITHDRAW_ERR);
        }
    }

    @Override
    public List<WithdrawLocalResponse> list(WithdrawLocalRequest request) {
        QueryWrapper<PrizeLogLocal> query = withdrawDao.getQuery();
        if(null == query){
            query = Wrappers.query(new PrizeLogLocal()
                    .setAppId(request.getAppid())
                    .setUid(request.getUid())
                    .setActivityType(appConfigFetcher.activityType())
            );
        }
        return withdrawDao.getResponse(iPrizeLogService.list(query));
    }
}
