package com.bxm.game.common.core.withdraw.dao;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.game.common.core.withdraw.WithdrawLocalRequest;
import com.bxm.game.common.core.withdraw.WithdrawLocalResponse;
import com.bxm.game.common.dal.entity.PrizeLogLocal;

/**
 * 提现服务扩展-本地版<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/20 10:55
 */
public interface WithdrawLocalDao {

    /**
     * 校验提现条件
     *
     * @param request 提现信息
     * @param attach 附件,用于内部参数传递
     * @return true: 可以提现
     */
    boolean check(WithdrawLocalRequest request, Map<Object, Object> attach);

    /**
     * 提现金额转元,用于标题
     *
     * @param request 提现信息
     * @param attach 附件,用于内部参数传递
     * @return
     */
    Double toYuan(WithdrawLocalRequest request, Map<Object, Object> attach);

    /**
     * 提现记录保存前,处理提现记录<br/>
     *
     * @param prizeLog 提现记录
     * @param attach 附件,用于内部参数传递
     */
    default void handlePrizeLog(PrizeLogLocal prizeLog, Map<Object, Object> attach){

    }

    /**
     * 获取提现记录的查询条件<br/>
     *
     * @return
     */
    default QueryWrapper<PrizeLogLocal> getQuery(){
        return null;
    }

    /**
     * 获取提现记录的查询结果<br/>
     *
     * @param logList
     * @return
     */
    default List<WithdrawLocalResponse> getResponse(List<PrizeLogLocal> logList){
        return logList.stream().map((e) -> {
            return new WithdrawLocalResponse()
                    .setId(e.getId())
                    .setOrderId(e.getOrderId())
                    .setAppId(e.getAppId())
                    .setUid(e.getUid())
                    .setStatus(e.getStatus())
                    .setCreateTime(e.getCreateTime())
                    .setName(e.getName())
                    .setMobile(e.getMobile())
                    .setPayType(e.getPayType())
                    .setAccount(e.getAccount())
                    .setAmount(e.getAmount())
                    ;
        }).collect(Collectors.toList());
    }
}
