package com.bxm.game.common.dal.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.game.common.dal.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

/**
 * <p>
 * 
 * </p>
 *
 * @author Allen Hu
 * @since 2020-12-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(AcquiredPropLog.TABLE_NAME_DYNAMIC_MAPPING)
public class AcquiredPropLog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    public static final String TABLE_NAME_DYNAMIC_MAPPING = "DynamicMappingForAcquiredPropLog";
    public static final String TABLE_NAME_PREFIX = "acquired_prop_log_";

    /**
     * 道具发放ID
     */
    private String id;

    private String appId;

    private String uid;

    private String assetType;

    private String sceneType;

    /**
     * 道具数量
     */
    private Integer propNum;

    /**
     * 倍数
     */
    private Integer multipleNum;

    /**
     * 翻倍状态：0-未翻倍、1-已翻倍，如果是已翻倍求和应该是 num*multiple
     */
    private Integer completedMultiple;

    /**
     * 状态：0-未领取、1-已领取
     */
    private Integer acquired;

    private Long startAcquireTime;

    private Long endAcquireTime;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;


    public static final String ID = "id";

    public static final String APP_ID = "app_id";

    public static final String UID = "uid";

    public static final String ASSET_TYPE = "asset_type";

    public static final String SCENE_TYPE = "scene_type";

    public static final String PROP_NUM = "prop_num";

    public static final String MULTIPLE_NUM = "multiple_num";

    public static final String COMPLETED_MULTIPLE = "completed_multiple";

    public static final String ACQUIRED = "acquired";

    public static final String START_ACQUIRE_TIME = "start_acquire_time";

    public static final String END_ACQUIRE_TIME = "end_acquire_time";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static String getTableName() {
        return getTableName(0);
    }

    public static String getTableName(int daysToAdd) {
        return TABLE_NAME_PREFIX + LocalDate.now().plusDays(daysToAdd).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    public AcquiredPropLog setCompletedMultiple(boolean flag) {
        this.completedMultiple = flag ? YES : NO;
        return this;
    }
    public AcquiredPropLog setAcquired(boolean flag) {
        this.acquired = flag ? YES : NO;
        return this;
    }

    public boolean isTypeOfCompletedMultiple() {
        return Objects.nonNull(this.completedMultiple) && this.completedMultiple.equals(YES);
    }

    public boolean isTypeOfAcquired() {
        return Objects.nonNull(this.acquired) && this.acquired.equals(YES);
    }
}
