package com.bxm.game.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.bxm.game.common.dal.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author Allen Hu
 * @since 2020-11-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PrizeLog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private String appId;

    private String uid;

    /**
     * 1、已提交；2、已发放
     */
    private Integer status;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;

    private Long prizeId;

    private String prizeName;

    private String name;

    private String mobile;

    private String address;


    public static final String ID = "id";

    public static final String APP_ID = "app_id";

    public static final String UID = "uid";

    public static final String STATUS = "status";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

    public static final String PRIZE_ID = "prize_id";

    public static final String PRIZE_NAME = "prize_name";

    public static final String NAME = "name";

    public static final String MOBILE = "mobile";

    public static final String ADDRESS = "address";

}
