package com.bxm.game.common.dal.entity;

import com.bxm.game.common.dal.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 指标信息
 * </p>
 *
 * @author Allen Hu
 * @since 2021-08-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class KpiInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 指标代码
     */
    private String kpiCode;

    /**
     * 指标名称
     */
    private String kpiName;

    /**
     * 指标说明
     */
    private String kpiDesc;


    public static final String KPI_CODE = "kpi_code";

    public static final String KPI_NAME = "kpi_name";

    public static final String KPI_DESC = "kpi_desc";

}
