package com.bxm.game.common.dal.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.bxm.game.common.dal.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 兑换奖品晒单
 * </p>
 *
 * @author Allen Hu
 * @since 2021-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PrizeLogShow extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 订单号
     */
    private String orderId;

    /**
     * appid
     */
    private String appId;

    /**
     * 变现猫用户ID
     */
    private String uid;

    /**
     * app用户ID
     */
    private String appUid;

    /**
     * 图片列表
     */
    private String imgs;

    /**
     * 描述
     */
    private String desc;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime modifyTime;


    public static final String ID = "id";

    public static final String ORDER_ID = "order_id";

    public static final String APP_ID = "app_id";

    public static final String UID = "uid";

    public static final String APP_UID = "app_uid";

    public static final String IMGS = "imgs";

    public static final String DESC = "desc";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

}
