package com.bxm.game.common.dal.enums;

/**
 * 资金流水枚举<br/>
 *
 * @author kerry.jiang
 * @date 2021/1/12 14:31
 */
public class EPrizeLog {

    /**
     * 发放状态<br/>
     *
     * @author kerry.jiang
     * @date 2021/1/12 14:31
     */
    public static enum Status {

        /**
         * 待发放
         */
        GRANT_PENDING(1, "待发放"),
        /**
         * 已发放
         */
        GRANT_OK(2, "已发放"),
        /**
         * 已放弃
         */
        WAIVER(3, "已放弃"),
        ;

        private int id;
        private String desc;

        private Status(int id, String desc){
            this.id = id;
            this.desc = desc;
        }

        public int getId() {
            return id;
        }

        public String getDesc() {
            return desc;
        }
    }

    /**
     * 支付渠道/类型<br/>
     *
     * @author kerry.jiang
     * @date 2021/1/12 14:31
     */
    public static enum PayType {

        /**
         * 无
         */
        NONE(0, "无"),
        /**
         * 支付宝
         */
        ALI_PAY(1, "支付宝"),
        /**
         * 微信支付
         */
        WX_PAY(2, "微信支付"),
        ;

        private int id;
        private String desc;

        private PayType(int id, String desc){
            this.id = id;
            this.desc = desc;
        }

        public int getId() {
            return id;
        }

        public String getDesc() {
            return desc;
        }
    }
}
