package com.bxm.game.scene.common.core;

/**
 * 常量<br/>
 *
 * @author kerry.jiang
 * @date 2021/1/12 18:45
 */
public interface DefaultConsts {

    /**
     * 默认游戏代码
     */
    String DEFAULT_GAME_CODE = "000";
    /**
     * 保留时长 - 永久
     */
    int TTL_PERMANENT = -1;
    /**
     * 保留时长 - 10分钟
     */
    int TTL_TEMPORARY = 10 * 60;
    /**
     * 保留时长 - 1天
     */
    int TTL_TODAY = 60 * 60 * 24 * 1;

    /**
     * 保留时长 - 1天
     */
    int TTL_DAYS = 60 * 60 * 24;
    /**
     * 保留时长 - 1周
     */
    int TTL_WEEKS = 60 * 60 * 24 * 7;

    /**
     * 场景attach中的field
     */
    interface Attach {
        /**
         * 回滚频次
         */
        String ROLLBACK_FREQ = "ROLLBACK_FREQ";

        /**
         * 备用1
         */
        String F_1 = "F_1";
        /**
         * 备用2
         */
        String F_2 = "F_2";
        /**
         * 备用3
         */
        String F_3 = "F_3";
        /**
         * 备用4
         */
        String F_4 = "F_4";
        /**
         * 备用5
         */
        String F_5 = "F_5";
        /**
         * 备用6
         */
        String F_6 = "F_6";
        /**
         * 备用7
         */
        String F_7 = "F_7";
        /**
         * 备用8
         */
        String F_8 = "F_8";
    }
}
