package com.bxm.game.scene.common.core.api.user;

import java.util.Collection;
import java.util.Map;

/**
 * 用户映射服务<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/30 14:11
 */
public interface BxmUserMappingService {

    /**
     * 根据变现猫用户ID获取媒体的用户ID<br/>
     *
     * @param appid appid
     * @param uid 变现猫用户ID
     * @return
     */
    default String getByUid(String appid, String uid){
        return getByUid(appid, uid, false);
    }

    /**
     * 根据变现猫用户ID获取媒体的用户ID<br/>
     *
     * @param appid appid
     * @param uid 变现猫用户ID
     * @param skipCache 是否跳过缓存
     * @return
     */
    String getByUid(String appid, String uid, boolean skipCache);

    /**
     * 根据变现猫用户ID获取媒体的用户ID<br/>
     *
     * @param appid appid
     * @param uids 变现猫用户ID
     * @return
     */
    Map<String, String> getByUids(String appid, Collection<String> uids);

    /**
     * 根据媒体的用户ID获取变现猫用户ID<br/>
     *
     * @param appid appid
     * @param cuid 媒体的用户ID
     * @return
     */
    default String getByCuid(String appid, String cuid) {
        return getByCuid(appid, cuid, false);
    }

    /**
     * 根据媒体的用户ID获取变现猫用户ID<br/>
     *
     * @param appid appid
     * @param cuid 媒体的用户ID
     * @param skipCache 是否跳过缓存
     * @return
     */
    String getByCuid(String appid, String cuid, boolean skipCache);

    /**
     * 根据媒体的用户ID获取资产账号id
     * @param appid appId
     * @param cuid 媒体用户ID
     * @return 资产账号id
     */
    default String getAssetByCuid(String appid, String cuid){
        return getAssetByCuid(appid, cuid, false);
    }

    /**
     * 根据媒体的用户ID获取资产账户id
     * @param appid appId
     * @param cuid 媒体用户ID
     * @param skipCache 是否跳过缓存
     * @return 资产账户id
     */
    String getAssetByCuid(String appid, String cuid, boolean skipCache);

    /**
     * 根据资产账户id批量获取最近绑定的媒体用户ID列表
     * @param appid appId
     * @param ids 资产账户id列表
     * @return 媒体用户ID列表
     */
    Map<String, String> getAssetLastByIds(String appid, Collection<String> ids);
}
