package com.bxm.game.scene.common.core.assets;

import java.util.Map;

/**
 * 资产服务
 *
 * @author allen
 * @date 2020-11-26
 * @since 1.0
 */
public interface AssetService {

    /**
     * 增加资产
     *
     * @param type 资产类型
     * @param value 资产值
     * @return 增加之后的值
     */
    default long plus(String type, long value) {
        return plus(type, value, null);
    }

    /**
     * 增加资产
     *
     * @param type 资产类型
     * @param value 资产值
     * @param act 增加资产的行为
     * @return 增加之后的值
     */
    long plus(String type, long value, String act);

    /**
     * 减少资产
     * @param type 资产类型
     * @param value 资产值
     * @return 减少之后的值
     */
    default long minus(String type, long value) {
        return minus(type, value, null);
    }

    /**
     * 减少资产
     * @param type 资产类型
     * @param value 资产值
     * @param act 减少资产的行为
     * @return 减少之后的值
     */
    long minus(String type, long value, String act);

    /**
     * 获取资产
     *
     * @param type 资产类型
     * @return 资产
     */
    long get(String type);

    /**
     * 获取资产，当不存在时返回 {@code defaultValue}
     * @param type 资产类型
     * @param defaultValue 不存在时返回值
     * @return 资产
     */
    long get(String type, long defaultValue);

    /**
     * 设置资产
     * @param type 资产类型
     * @param value 资产值
     */
    void set(String type, long value);

    /**
     * 删除资产数据
     * @param type 资产类型
     */
    void delete(String type);

    /**
     * 获取全部资产
     *
     * @return 资产
     */
    Map<String, Object> getAll();
}
