package com.bxm.game.scene.common.core.assets.dao;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.DefaultRedisKeyType;
import com.bxm.game.scene.common.core.user.PermanentAtomicService;

/**
 * 用户资产信息<br/>
 *
 * @author kerry.jiang
 * @date 2021/10/25 16:51
 */
public class RedisAssetDaoImpl implements AssetDao {

    private final AppConfigFetcher appConfigFetcher;
    private final PermanentAtomicService permanentAtomicService;

    public RedisAssetDaoImpl(AppConfigFetcher appConfigFetcher, PermanentAtomicService permanentAtomicService) {
        this.appConfigFetcher = appConfigFetcher;
        this.permanentAtomicService = permanentAtomicService;
    }

    @Override
    public long plus(String type, long value) {
        return permanentAtomicService.hIncrBy(DefaultRedisKeyType.ASSET, type, value);
    }

    @Override
    public long minus(String type, long value) {
        return permanentAtomicService.hIncrBy(DefaultRedisKeyType.ASSET, type, -value);
    }

    @Override
    public long get(String type) {
        return get(type, 0);
    }

    @Override
    public long get(String type, long defaultValue) {
        return permanentAtomicService.hGet(DefaultRedisKeyType.ASSET, type, defaultValue);
    }

    @Override
    public void set(String type, long value) {
        permanentAtomicService.hSet(DefaultRedisKeyType.ASSET, type, String.valueOf(value));
    }

    @Override
    public void delete(String type) {
        permanentAtomicService.hDel(DefaultRedisKeyType.ASSET, type);
    }

    @Override
    public Map<String, Object> getAll() {
        Map<String, Object> rst = new HashMap<>();
        Map<String, String> map = permanentAtomicService.hGetAll(DefaultRedisKeyType.ASSET, String.class);
        if (MapUtils.isEmpty(map)) {
            return rst;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (NumberUtils.isCreatable(value)) {
                rst.put(key, NumberUtils.toInt(value));
            } else {
                rst.put(key, value);
            }
        }
        return rst;
    }
}
