package com.bxm.game.scene.common.core.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.assets.dao.AssetDao;
import com.bxm.game.scene.common.core.assets.dao.DbAssetDaoImpl;
import com.bxm.game.scene.common.core.prop.dao.DbPropDaoImpl;
import com.bxm.game.scene.common.core.prop.dao.PropDao;
import com.bxm.game.scene.common.dal.service.IAcquiredPropLogService;

/**
 * @author allen
 * @date 2020-12-15
 * @since 1.0
 */
@ConditionalOnProperty(name = "game.datasource.type", havingValue = "db")
public class DbAutoConfiguration {

    @Bean
    public static PropDao propDao(AppConfigFetcher appConfigFetcher, IAcquiredPropLogService acquiredPropLogService) {
        return new DbPropDaoImpl(appConfigFetcher, acquiredPropLogService);
    }

    @Bean
    public static AssetDao assetDao() {
        return new DbAssetDaoImpl();
    }
}
