package com.bxm.game.scene.common.core.autoconfigure;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.assets.dao.AssetDao;
import com.bxm.game.scene.common.core.assets.dao.RedisAssetDaoImpl;
import com.bxm.game.scene.common.core.prop.dao.PropDao;
import com.bxm.game.scene.common.core.prop.dao.RedisPropDaoImpl;
import com.bxm.game.scene.common.core.user.PermanentAtomicService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;

/**
 * @author allen
 * @date 2020-12-15
 * @since 1.0
 */
@ConditionalOnProperty(name = "game.datasource.type", havingValue = "redis", matchIfMissing = true)
public class RedisAutoConfiguration {

    @Bean
    public static PropDao propDao(AppConfigFetcher appConfigFetcher,
                                  @Qualifier("jedisFetcher") Fetcher fetcher,
                                  @Qualifier("jedisUpdater") Updater updater) {
        return new RedisPropDaoImpl(appConfigFetcher, fetcher, updater);
    }

    @Bean
    public static AssetDao assetDao(AppConfigFetcher appConfigFetcher, PermanentAtomicService permanentAtomicService) {
        return new RedisAssetDaoImpl(appConfigFetcher, permanentAtomicService);
    }
}
