package com.bxm.game.scene.common.core.autoconfigure.app;

import com.bxm.game.scene.common.core.bean.AppContext;

/**
 * app配置内容填充<br/>
 *
 * @author kerry.jiang
 * @date 2021/10/25 18:30
 */
public interface BaseAppConfigService<T> {

    /**
     * 获取配置信息<br/>
     *
     * @return
     */
    default T getConfig(){
        return getConfig(AppContext.get().getGameCode(), AppContext.get().getAppId());
    }

    /**
     * 获取配置信息<br/>
     *
     * @param gcode 游戏代码
     * @param appid appid
     * @return
     */
    T getConfig(String gcode, String appid);

    /**
     * 获取实时配置信息
     * @param gcode 游戏代码
     * @param appid appid
     * @return
     */
    T getRealConfig(String gcode, String appid);

    /**
     * 获取值
     * @param fixed 固定值
     * @param min 最小值（包含）
     * @param max 最大值（包含）
     * @return
     */
    default Integer getNum(Integer fixed, Integer min, Integer max){
        return getNum(fixed, min, max, 0);
    }

    /**
     * 获取值
     * @param fixed 固定值
     * @param min 最小值（包含）
     * @param max 最大值（包含）
     * @param defaultVal 默认值
     * @return
     */
    Integer getNum(Integer fixed, Integer min, Integer max, Integer defaultVal);
}
