package com.bxm.game.scene.common.core.autoconfigure.app;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;

import lombok.extern.slf4j.Slf4j;

/**
 * app配置内容填充<br/>
 *
 * @author kerry.jiang
 * @date 2021/10/27 11:42
 */
@Slf4j
public abstract class BaseAppConfigServiceImpl<T> implements BaseAppConfigService<T> {

    /**
     * 缓存配置
     */
    private final LoadingCache<String, Optional<T>> configCache = CacheBuilder.newBuilder()
            .expireAfterWrite(5, TimeUnit.MINUTES)
            .build(new CacheLoader<String, Optional<T>>() {
                @Override
                public Optional<T> load(String key) {
                    return Optional.empty();
                }
            });

    @Override
    public T getConfig(String gcode, String appid) {
        T t = getConfig0(gcode, appid);
        if(Objects.isNull(t)){
            throw new RuntimeException("Not find config, gcode="+gcode+",appid="+appid);
        }
        return t;
    }

    /**
     * 读取配置信息
     */
    private T getConfig0(String gcode, String appid){
        try {
            Optional<T> appConfig = configCache.get(appid, () ->{
                T t = getRealConfig(gcode, appid);
                return Optional.ofNullable(t);
            });
            return appConfig.orElse(null);
        }catch (Exception e){
            log.error("getConfig0 error: gcode={},appid={},e={}",
                    gcode, appid, ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    @Override
    public Integer getNum(Integer fixed, Integer min, Integer max, Integer defaultVal) {
        if(null != fixed){
            return Optional.ofNullable(fixed).orElse(defaultVal);
        }
        if(null != min && null != max){
            return RandomUtils.nextInt(min, max+1);
        }
        return defaultVal;
    }
}
