package com.bxm.game.scene.common.core.autoconfigure.app;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 配置项通用类<br/>
 *
 * @author kerry.jiang
 * @date 2021/11/10 11:30
 */
@Data
@Accessors(chain = true)
public abstract class SceneCommonConfig<Child extends SceneCommonConfig> {

    /**
     * 资产类型
     */
    protected Integer assetType;
    /**
     * 固定奖励
     */
    protected Integer fixed;
    /**
     * 最小奖励
     */
    protected Integer min;
    /**
     * 最大奖励
     */
    protected Integer max;
    /**
     * 固定频次
     */
    protected Integer freqFixed;
    /**
     * 最小频次
     */
    protected Integer freqMin;
    /**
     * 最大频次
     */
    protected Integer freqMax;
    /**
     * 资产可翻倍数(大于1表示不翻倍)
     */
    protected Number multiple;
    /**
     * 可翻倍固定频次
     */
    protected Integer multipleFreqFixed;
    /**
     * 可翻倍最小频次
     */
    protected Integer multipleFreqMin;
    /**
     * 可翻倍最大频次
     */
    protected Integer multipleFreqMax;

    /**
     * 获取子类对象
     *
     * @return 子类对象
     */
    public abstract Child get();
}
