package com.bxm.game.scene.common.core.bean;

import com.bxm.game.scene.common.core.ErrCode;

/**
 * @author allen
 * @date 2020-10-16
 * @since 1.0
 */
public class GameException extends RuntimeException {

    private final ErrCode errCode;

    public GameException(ErrCode errCode) {
        this.errCode = errCode;
    }

    public GameException(String message, ErrCode errCode) {
        super(message);
        this.errCode = errCode;
    }

    public GameException(String message, Throwable cause, ErrCode errCode) {
        super(message, cause);
        this.errCode = errCode;
    }

    public GameException(Throwable cause, ErrCode errCode) {
        super(cause);
        this.errCode = errCode;
    }

    public GameException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, ErrCode errCode) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.errCode = errCode;
    }

    public ErrCode getErrCode() {
        return errCode;
    }
}
