package com.bxm.game.scene.common.core.fun.action;

import org.apache.commons.lang.StringUtils;

import com.bxm.warcar.utils.JsonHelper;

/**
 * 获取执行信息<br/>
 *
 * @author kerry.jiang
 * @date 2021/4/22 18:14
 */
public interface SceneActionFetcher<RQ extends SceneActionRequest, RS extends SceneActionResponse>{

    /**
     * 返回场景类型
     * @return 场景类型
     */
    String getSceneType();

    /**
     * 返回请求对象类
     * @return 请求对象类
     */
    Class<RQ> getActionRequestClass();

    /**
     * 执行
     * @param request 请求信息
     * @return 执行结果
     */
    RS action(RQ request);

    /**
     * 获取请求信息
     * @param message
     * @return
     */
    default RQ convertAction(String message) {
        if (StringUtils.isBlank(message)) {
            try {
                return getActionRequestClass().newInstance();
            }catch (Exception e){
                return null;
            }
        }
        return JsonHelper.convert(message, getActionRequestClass());
    }
}
