package com.bxm.game.scene.common.core.fun.action;

import java.util.Map;

import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * 场景执行信息<br/>
 *
 * @author kerry.jiang
 * @date 2021/4/22 18:24
 */
@Slf4j
public class SceneActionServiceFactory implements ApplicationListener<ApplicationReadyEvent> {

    private final Map<String, SceneActionFetcher> map = Maps.newHashMap();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map<String, SceneActionFetcher> beans = applicationContext.getBeansOfType(SceneActionFetcher.class);
        for (SceneActionFetcher service : beans.values()) {
            map.put(service.getSceneType(), service);
            log.info("Registering SceneActionFetcher to Factory: {}", service);
        }
    }

    public SceneActionFetcher get(String sceneType) {
        return map.get(sceneType);
    }
}
