package com.bxm.game.scene.common.core.fun.archives;

import java.util.Map;

import com.bxm.game.scene.common.core.prop.Prop;
import com.bxm.game.scene.common.core.scene.SceneResponse;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author allen
 * @date 2020-12-08
 * @since 1.0
 */
public abstract class AbstractDefinedObjectTypeCustomArchiveHandler extends AbstractCustomArchiveHandler<AbstractDefinedObjectTypeCustomArchiveHandler.DefinedObject> {

    @Override
    public Class<DefinedObject> getClazz() {
        return DefinedObject.class;
    }

    @Override
    public DefinedObject createArchiveObject(Prop prop, Map<Object, Object> attach, SceneResponse response) {
        return DefinedObject.builder()
                .id(response.getId())
                .assetType(response.getAssetType())
                .propNum(response.getPropNum())
                .multipleNum(response.getMultipleNum())
                .build();
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    static class DefinedObject {
        private String id;
        private String assetType;
        private int propNum;
        private Number multipleNum;
    }
}
