package com.bxm.game.scene.common.core.fun.archives;

import java.util.Collection;

/**
 * 自定义存档数据服务
 *
 * @author allen
 * @date 2020-12-08
 * @since 1.0
 */
public interface CustomArchiveDataService {

    /**
     * 按 hash 方式存储
     * @param archive 存档数据
     */
    void hset(CustomArchive archive);

    /**
     * 从已存在的 hash 中删除
     * @param key hash key
     * @param field hash field
     */
    void hdel(String key, String field);

    /**
     * 按 hash 方式获取所有的数据
     * @param key Key
     * @param clazz 对象类型
     * @param <T> T
     * @return 数据集
     */
    <T> Collection<T> hgetAll(String key, Class<T> clazz);
}
