package com.bxm.game.scene.common.core.fun.archives;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

import java.util.Map;
import java.util.Set;

/**
 * @author allen
 * @date 2020-12-01
 * @since 1.0
 */
@Slf4j
public class CustomArchiveHandlerFactory implements ApplicationListener<ApplicationReadyEvent> {

    private final Set<CustomArchiveHandler> handlers = Sets.newHashSet();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        Map<String, CustomArchiveHandler> beans = event.getApplicationContext().getBeansOfType(CustomArchiveHandler.class);
        for (CustomArchiveHandler bean : beans.values()) {
            handlers.add(bean);
            log.info("Registering CustomArchiveHandler to Factory: {}", bean);
        }
    }

    public ImmutableSet<CustomArchiveHandler> getHandlers() {
        return ImmutableSet.copyOf(handlers);
    }
}
