package com.bxm.game.scene.common.core.fun.archives;

import com.bxm.game.scene.common.core.scene.SceneService;
import com.bxm.game.scene.common.core.scene.event.AcquiredPropEvent;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * @author allen
 * @date 2020-12-08
 * @since 1.0
 */
public class CustomArchiveHandlingListener implements EventListener<AcquiredPropEvent> {

    private final CustomArchiveDataService customArchiveDataService;

    public CustomArchiveHandlingListener(CustomArchiveDataService customArchiveDataService) {
        this.customArchiveDataService = customArchiveDataService;
    }

    @Override
    @Subscribe
    public void consume(AcquiredPropEvent event) {
        CustomArchiveHandler handler = getCustomArchiveHandler(event);
        if (Objects.isNull(handler)) {
            return;
        }
        if (!(handler instanceof SceneCustomArchiveHandler)) {
            return;
        }
        final SceneCustomArchiveHandler sceneCustomArchiveHandler = (SceneCustomArchiveHandler) handler;
        String id = event.getId();
        KeyGenerator key = sceneCustomArchiveHandler.getKey();
        String field = sceneCustomArchiveHandler.getDisplayFieldName();
        Object object = sceneCustomArchiveHandler.createArchiveObject(event.getProp(), event.getAttach(), event.getSceneResponse());
        if (Objects.isNull(key) || StringUtils.isBlank(field) || Objects.isNull(object)) {
            return;
        }
        customArchiveDataService.hset(CustomArchive.builder()
                .key(key.generateKey())
                .field(id)
                .value(object)
                .expireTimeInSeconds(sceneCustomArchiveHandler.getExpireTimeInSecond())
                .build());
    }

    private CustomArchiveHandler getCustomArchiveHandler(AcquiredPropEvent event) {
        Object source = event.getSource();
        CustomArchiveHandler handler = null;
        if ((source instanceof CustomArchiveHandler)) {
            handler = (CustomArchiveHandler) source;
        } else if (source instanceof SceneService) {
            handler = ((SceneService) source).getCustomArchiveHandler();
        }
        return handler;
    }
}
