package com.bxm.game.scene.common.core.fun.archives;

import java.util.Map;

import com.bxm.game.scene.common.core.prop.Prop;
import com.bxm.game.scene.common.core.scene.SceneResponse;
import com.bxm.warcar.cache.KeyGenerator;

/**
 * @author allen
 * @date 2020-12-10
 * @since 1.0
 * @see AbstractCustomArchiveHandler
 * @see AbstractDefinedObjectTypeCustomArchiveHandler
 */
public interface SceneCustomArchiveHandler<T> extends CollectionCustomArchiveHandler<T> {

    /**
     * 存储时使用的主键
     * @return 主键，不能重复
     */
    KeyGenerator getKey();

    /**
     * 数据将在多少秒后过期
     * @return 秒
     */
    default int getExpireTimeInSecond() {
        return 24 * 60 * 60;
    }

    /**
     * 存档的数据类型
     * @return 泛类型
     */
    Class<T> getClazz();

    /**
     * 创建一个需要存储的存档对象
     * @param prop 道具
     * @param attach 附件
     * @param response 响应
     * @return 存档
     */
    T createArchiveObject(Prop prop, Map<Object, Object> attach, SceneResponse response);
}
