package com.bxm.game.scene.common.core.fun.archives.annotation;


import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.bxm.game.scene.common.core.scene.DefaultSceneType;

/**
 * 完成即删除
 *
 * @author allen
 * @date 2020-11-24
 * @since 1.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface DeleteOnCompleted {

    /**
     * 在这些场景下才会执行删除
     * @return 场景列表
     */
    String[] sceneTypes() default {DefaultSceneType.ACQUIRE, DefaultSceneType.MULTIPLE};
}
