package com.bxm.game.scene.common.core.fun.config;

import java.util.Map;

import com.bxm.warcar.utils.JsonHelper;

/**
 * 获取配置信息<br/>
 *
 * @author kerry.jiang
 * @date 2021/4/22 18:14
 */
public interface SceneConfigFetcher <RQ extends SceneConfigRequest, RS extends SceneConfigResponse>{

    /**
     * 返回场景类型
     * @return 场景类型
     */
    String getSceneType();

    /**
     * 获取配置信息
     * @param paramMap 请求信息
     * @return 配置信息
     */
    default RS getConfig(Map paramMap){
        RQ request;
        if(paramMap.isEmpty()){
            try {
                request = getConfigRequestClass().newInstance();
            }catch (Exception e){
                return null;
            }
        }else{
            request = JsonHelper.convert(JsonHelper.convert(paramMap), getConfigRequestClass());
        }
        return getConfig(request);
    }

    /**
     * 返回请求对象类
     * @return 请求对象类
     */
    Class<RQ> getConfigRequestClass();

    /**
     * 获取配置信息
     * @param request 请求信息
     * @return 配置信息
     */
    RS getConfig(RQ request);
}
